from pydantic import BaseModel, Field
from datetime import datetime
from typing import Optional, List

class PartnerBase(BaseModel):
    partner_name: str
    title: str
    industry: Optional[str] = None

    # User information
    user_id: Optional[str] = "" #Master user id
    name: Optional[str] = ""
    email: Optional[str] = ""
    mobile: Optional[str] = ""

    # Partner details
    address: Optional[str] = ""
    city: Optional[str] = ""
    state: Optional[str] = ""
    country: Optional[str] = ""
    postal_code: Optional[str] = ""
    
    # Status
    is_active: Optional[bool] = True
    created_date: Optional[datetime] = Field(default_factory=datetime.utcnow)
    
    # Subscription information
    partner_type: int = 0  # free 0 / premium 2 / startup 1 / enterprise 3
    active_subscription_id: Optional[str] = None
    subscription_status: Optional[str] = None

# Define Partner as a subclass of PartnerBase.
class Partner(PartnerBase):
    """A complete Partner model that can be extended with extra fields if needed."""
    pass

class PartnerCreate(PartnerBase):
    pass

class PartnerUpdate(PartnerBase):
    roles: int = 3

class PartnerList(PartnerBase):
    partner_id: str

class Partners(BaseModel):
    total_count: int
    partners: List[PartnerList]
